/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers.data;

import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.Server;
import noppes.npcs.api.IContainer;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.handler.data.IAvailability;
import noppes.npcs.api.handler.data.IDeal;
import noppes.npcs.api.item.IItemStack;
import noppes.npcs.api.wrapper.ItemStackWrapper;
import noppes.npcs.constants.EnumPacketClient;
import noppes.npcs.controllers.MarcetController;
import noppes.npcs.controllers.data.Availability;
import noppes.npcs.controllers.data.Marcet;

public class Deal
implements IDeal {
    public Availability availability = new Availability();
    private float chance = 1.0f;
    private int[] count = new int[]{0, 0};
    private int id = -1;
    private boolean ignoreDamage = false;
    private boolean ignoreNBT = false;
    private final NpcMiscInventory inventoryCurrency = new NpcMiscInventory(9);
    private final NpcMiscInventory inventoryProduct = new NpcMiscInventory(1);
    private int money = 0;
    private int type = 2;
    private int amount = 1;
    public boolean update;

    public Deal() {
    }

    public Deal(int id) {
        this.id = id;
    }

    public Deal copy() {
        Deal deal = new Deal(this.id);
        deal.availability = this.availability;
        deal.ignoreDamage = this.ignoreDamage;
        deal.ignoreNBT = this.ignoreNBT;
        for (int i = 0; i < 9; ++i) {
            deal.inventoryCurrency.func_70299_a(i, this.inventoryCurrency.func_70301_a(i).func_77946_l());
        }
        deal.inventoryProduct.func_70299_a(0, this.inventoryProduct.func_70301_a(0).func_77946_l());
        deal.type = this.type;
        deal.money = this.money;
        deal.count[0] = this.count[0];
        deal.count[1] = this.count[1];
        deal.chance = this.chance;
        deal.amount = this.amount;
        return deal;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public IAvailability getAvailability() {
        return this.availability;
    }

    @Override
    public int getChance() {
        return (int)(this.chance * 100.0f);
    }

    @Override
    public IContainer getCurrency() {
        return Objects.requireNonNull(NpcAPI.Instance()).getIContainer(this.inventoryCurrency);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean getIgnoreDamage() {
        return this.ignoreDamage;
    }

    @Override
    public boolean getIgnoreNBT() {
        return this.ignoreNBT;
    }

    @Override
    public int getMaxCount() {
        return this.count[1];
    }

    @Override
    public IInventory getMCInventoryCurrency() {
        return this.inventoryCurrency;
    }

    @Override
    public IInventory getMCInventoryProduct() {
        return this.inventoryProduct;
    }

    @Override
    public int getMinCount() {
        return this.count[0];
    }

    @Override
    public int getMoney() {
        return this.money;
    }

    @Override
    public String getName() {
        StringBuilder name = new StringBuilder();
        ItemStack stack = this.inventoryProduct.func_70301_a(0);
        if (!stack.func_190926_b()) {
            name.append(this.count[1] != 0 && this.amount == 0 ? "\u00a7c" : "").append("x").append(stack.func_190916_E()).append(" ").append(stack.func_82833_r());
        } else {
            name.append(" - Empty");
        }
        return name.toString();
    }

    @Override
    public IItemStack getProduct() {
        return Objects.requireNonNull(NpcAPI.Instance()).getIItemStack(this.inventoryProduct.func_70301_a(0));
    }

    public String getSettingName() {
        ItemStack stack = this.inventoryProduct.func_70301_a(0);
        return "ID:" + this.id + " " + (stack.func_190926_b() ? "\u00a74" + new TextComponentTranslation("type.empty", new Object[0]).func_150254_d() : (this.inventoryCurrency.func_191420_l() && this.money == 0 ? "\u00a7c" : "") + stack.func_82833_r()) + (!stack.func_190926_b() ? " x" + stack.func_190916_E() : "");
    }

    @Override
    public int getType() {
        return this.type;
    }

    public boolean isValid() {
        this.inventoryProduct.func_70301_a(0);
        return !this.inventoryProduct.func_70301_a(0).func_190926_b() && (this.money > 0 || !this.inventoryCurrency.func_191420_l());
    }

    public void readDataNBT(NBTTagCompound compound) {
        this.readFromNBT(compound);
        this.amount = compound.func_74762_e("Amount");
        this.id = compound.func_74762_e("DealID");
    }

    public void readFromNBT(NBTTagCompound compound) {
        this.availability.load(compound.func_74775_l("Availability"));
        this.ignoreDamage = compound.func_74767_n("IgnoreDamage");
        this.ignoreNBT = compound.func_74767_n("IgnoreNBT");
        this.inventoryCurrency.load(compound.func_74775_l("Currency"));
        this.inventoryProduct.load(compound.func_74775_l("Product"));
        this.type = compound.func_74762_e("Type");
        this.money = compound.func_74762_e("Money");
        this.count = compound.func_74759_k("Count");
        this.chance = compound.func_74760_g("Chance");
        this.id = compound.func_74762_e("DealID");
    }

    @Override
    public void set(IItemStack product, IItemStack[] currencys) {
        if (product == null) {
            product = ItemStackWrapper.AIR;
        }
        ItemStack[] cs = new ItemStack[currencys == null ? 0 : currencys.length];
        if (currencys != null) {
            int i = 0;
            for (IItemStack stack : currencys) {
                cs[i] = stack.getMCItemStack();
                ++i;
            }
        }
        this.set(product.getMCItemStack(), cs);
    }

    public void set(ItemStack product, ItemStack[] currencys) {
        if (product == null) {
            product = ItemStack.field_190927_a;
        }
        this.inventoryProduct.func_70299_a(0, product);
        if (this.count[1] != 0 && this.count[1] >= this.count[0]) {
            this.amount = 0;
            if (this.chance <= (float)Math.random()) {
                this.amount = this.count[0] + (int)(Math.random() * (double)(this.count[1] - this.count[0]));
            }
        } else {
            this.amount = 1;
        }
        this.inventoryCurrency.func_174888_l();
        if (currencys != null) {
            int j = 0;
            for (int i = 0; i < currencys.length; ++i) {
                if (currencys[i] == null || currencys[i].func_190926_b()) continue;
                this.inventoryCurrency.func_70299_a(j, currencys[i]);
                ++j;
            }
        }
    }

    @Override
    public void setAmount(int amount) {
        if (amount < 0) {
            amount = 0;
        }
        this.amount = amount;
        this.update = true;
    }

    public void setChance(float chance) {
        if (chance < 0.0f) {
            chance = 0.0f;
        } else if (chance > 1.0f) {
            chance = 1.0f;
        }
        this.chance = chance;
        this.update = true;
    }

    @Override
    public void setChance(int chance) {
        this.setChance((float)chance / 100.0f);
    }

    @Override
    public void setCount(int min, int max) {
        if (min < 0) {
            min *= -1;
        }
        if (max < 0) {
            max *= -1;
        }
        if (max < min) {
            int m = min;
            min = max;
            max = m;
        }
        this.count[0] = min;
        this.count[1] = max;
        this.update = true;
    }

    @Override
    public void setIgnoreDamage(boolean bo) {
        if (bo == this.ignoreDamage) {
            return;
        }
        this.ignoreDamage = bo;
        this.update = true;
    }

    @Override
    public void setIgnoreNBT(boolean bo) {
        if (bo == this.ignoreNBT) {
            return;
        }
        this.ignoreNBT = bo;
        this.update = true;
    }

    @Override
    public void setMoney(int money) {
        if (money < 0) {
            money = 0;
        }
        this.money = money;
        this.update = true;
    }

    @Override
    public void setProduct(IItemStack product) {
        if (product == null) {
            product = ItemStackWrapper.AIR;
        }
        this.inventoryProduct.func_70299_a(0, product.getMCItemStack());
    }

    @Override
    public void setType(int type) {
        if (type < 0) {
            type *= -1;
        }
        this.type = type % 3;
        this.update = true;
    }

    public void update() {
        if (this.update) {
            this.update = false;
            MarcetController mData = MarcetController.getInstance();
            NBTTagCompound nbt = this.writeDataToNBT();
            for (Marcet marcet : mData.markets.values()) {
                if (marcet.getSection(this.id) == -1) continue;
                for (EntityPlayer listener : marcet.listeners) {
                    if (!(listener instanceof EntityPlayerMP)) continue;
                    Server.sendData((EntityPlayerMP)listener, EnumPacketClient.MARCET_DATA, 5, marcet.getId(), nbt);
                    Server.sendData((EntityPlayerMP)listener, EnumPacketClient.MARCET_DATA, 2);
                }
            }
        }
    }

    @Override
    public void updateNew() {
        this.amount = this.chance >= (float)Math.random() ? (this.count[1] != 0 && this.count[1] >= this.count[0] ? this.count[0] + (int)(Math.random() * (double)(this.count[1] - this.count[0])) : 1) : 0;
    }

    public NBTTagCompound writeDataToNBT() {
        NBTTagCompound compound = this.writeToNBT();
        compound.func_74768_a("Amount", this.amount);
        return compound;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("Availability", (NBTBase)this.availability.save(new NBTTagCompound()));
        compound.func_74757_a("IgnoreDamage", this.ignoreDamage);
        compound.func_74757_a("IgnoreNBT", this.ignoreNBT);
        compound.func_74782_a("Currency", (NBTBase)this.inventoryCurrency.save());
        compound.func_74782_a("Product", (NBTBase)this.inventoryProduct.save());
        compound.func_74768_a("Type", this.type);
        compound.func_74783_a("Count", this.count);
        compound.func_74776_a("Chance", this.chance);
        compound.func_74768_a("DealID", this.id);
        compound.func_74768_a("Money", this.money);
        return compound;
    }
}

